% an_start: Main program for the data analysis
% GUISDAP v.1.60 96-05-27 Copyright Asko Huuskonen and Markku Lehtinen
% 
% Main program for the data analysis. The most important operations performed are
% routine name:  action:
% chk_par1       1) transforms the user supplied control parameters to internal parameters
%                2) checks the data source (matlab files/EISCAT .dtst files)
% init_graphics  opens a sufficient number of figure windows and defines there sizes etc.
% integr_NW      calls Nigel Wade's integration package, when EISCAT .dtst files are used
% integr_data    integrates data from Matlab files
% decodeparblock transfers the radar parameters (power etc) to internal GUISDAP parameters
% load_initfile  loads the ambiguity functions etc
% scale_lpgwom   scales the spectal amb. function with the correlator algorithm factors (lpg_ND)
% radar_eq       radar equation     
% scale_data     scales the data with the correlator algorithm factors (lpg_ND) 
% subr_backgr    background subtraction to the data  
% get_apriori    the a priori model, electron density obtained from the data
% half_prof      performs the gated analysis to the data 
% save_results   results stored to the disk
% plot_results   displays the results
%
% Other routines called: globals nat_const get_ADDRSHIFT  load_GUPvar GUIZARD GUISPERT form_adpar
%                       spektri_init constants chk_par2 simul_dump clear_results
  
%--- Appended by S. Saito ---
if exist('plot_alt'),global plot_alt0 val_alt, plot_alt0=plot_alt; val_alt=1; 
else global val_alt, val_alt=0; end
if ~exist('save_acf'),save_acf=[0 0]; end
global sv_acf
sv_acf=save_acf;
%----------------------------
t_init
t_start(1)

globals          % Defines (nearly) all global variables 
chk_par1
nat_const
get_ADDRSHIFT
init_graphics

rcprog_old=-1;
EOF=0;
while ~EOF,
 
  if any(a_simul)
    OK=1;EOF=1;
  else
    if a_rawdata,
      [OK,EOF]=integr_NW;
    else
      [OK,EOF]=integr_data;
    end
    if OK, decodeparblock; end
  end

%*************************************************************************************
%
% At this point, an integrated complex data dump is stored in variable d_data
% It is possible to study the contents of the data by graphical and other means, e.g.
% ind=1:length(d_data)-1; plot(ind-1,real(d_data(ind)));
%
%*************************************************************************************

  if OK,
    if d_rcprog~=rcprog_old  
      load_initfile   
      if a_control(4)>=2, load_GUPvar, end  
      if any(a_simul), simulparblock; end
      if exist('GUIZARD')==2, GUIZARD, end
      scale_lpgwom % scales the spectral ambiguity function with lpg_ND factors
      form_adpar   
      spektri_init % Loads in plasma dispersion function table
      constants    
      rcprog_old=d_rcprog;
    end
    if exist('GUISPERT')==2, GUISPERT, end
    radar_eq   % calculates the radar constant      
    chk_par2   
    
    if any(a_simul),
      simul_dump
    else
      scale_data   
    end

%*************************************************************************************
%
% Now the data has been scaled by calibration, so that it appears in units of K
% ind=0:length(d_data)-2; plot(ind,real(d_data(ind))); % This would show the data
%
%*************************************************************************************

    subr_backgr   

%*************************************************************************************
%
% At this point one finds background subtracted data in vector d_data
%
%*************************************************************************************

    if di_figures(1),
      figure(di_figures(1)); clf; ind=find(real(d_data>-200 & d_data<2000)); 
      plot(ind-1,real(d_data(ind))), title(' Correlator dump, real part'); 
      xlabel('Address'); ylabel('Power [K]'); grid; drawnow
      clear ind
    end    

    get_apriori(any(a_simul))

%*************************************************************************************
%
% The get_apriori call calculated the raw electron density profile. 
% It is stored in variables
% pp_range   : range to power measurements
% pp_profile : Ne with a priori temperature ratio model
% pp_sigma   : Ne with Te=Ti
%
%*************************************************************************************
  
    clear_results
%**************************************** 				
    half_prof 
%**************************************** 
    save_results
    if di_figures(4), 
      figure(di_figures(4)),
	  fprintf('\n Now using *** plot_fit *** to display results\n')
      plot_fit('panel',[1 1 1 0 1],[-inf inf max(10*ceil((max(r_h)-min(r_h))/100),10)]);drawnow 
    end
  end 

end
t_stop(1)
t_result
