%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                    %
%                                                                    %
%    ####   #####   ######   ####    #####  #####   #    #  #    #   %
%   #       #    #  #       #    #     #    #    #  #    #  ##  ##   %
%    ####   #    #  #####   #          #    #    #  #    #  # ## #   %
%        #  #####   #       #          #    #####   #    #  #    #   %
%   #    #  #       #       #    #     #    #   #   #    #  #    #   %
%    ####   #       ######   ####      #    #    #   ####   #    #   %
%                                                                    %
%   for Tromso UHF or VHF system                                     %
%                                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;clear all;
global result_path plot_start plot_end
global site pulse MIN_alt MAX_alt
global line_alt disp_alt disp_data disp_q disp_beam disp_sys
global disp_file disp_path disp_date disp_page PS_file
global title comment scale put_alt
config_spectrum_KST;

if site=='UHF' kst='t'; end
if site=='VHF' kst='v'; end

for i=1:2
 if i==1 time=plot_start; end
 if i==2 time=plot_end; end
 yd=365;
 if time(2)==1|time(2)==2 dif=0; end
 if time(2)==3|time(2)==4 dif=3; end
 if time(2)==5|time(2)==6 dif=4; end
 if time(2)==7|time(2)==8|plot_start(2)==9 dif=5; end
 if time(2)==10|time(2)==11 dif=6; end
 if time(2)==12 dif=7; end
 if rem(time(1),4)==0, % leap year
  yd=366;
  if time(2)>=3 dif=dif-1; end
 end
 ddd=(time(2)-1)*31+time(3)-dif; % 1<ddd<366
 if i==1 start_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
 if i==2 end_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
end % for i=1:2

fid=fopen([result_path 'filelist_acf.dat'],'r');
time0=fscanf(fid,'%s');
status=fclose(fid);

time1=zeros(1,length(time0)/11);
for i=1:length(time0)/11
 time1(1,i)=str2num(time0(i*11-7:i*11));
end
fitarr=find(time1>start_sec & time1<=end_sec);
if length(fitarr)==0
 fprintf(['******  PLEASE CHECK "plot_start" & "plot_end"  ******\n']);
end
time0=time0(fitarr(1)*11-10:fitarr(length(fitarr))*11);
time1=time1(fitarr);

filename=[result_path time0(1:11)];
eval(['load ' filename]);

height_arr=height_arr1;
if pulse=='LP' height_arr=height_arr2; end
fitalt=find(height_arr<=MAX_alt & height_arr>=MIN_alt);
if length(fitalt)==0
 fprintf(['******  PLEASE CHECK "MIN_alt" & "MAX_alt"  ******\n']);
end
ref_alt=height_arr(fitalt);

if line_alt=='0', % alt
 [del_alt,jj0]=min(abs(ref_alt-put_alt)); put_alt0=ref_alt(jj0);
 ref_alt_s=height_arr(find(height_arr<=put_alt0 & height_arr>=MIN_alt));
 ref_alt_e=height_arr(find(height_arr<=MAX_alt & height_arr>put_alt0));
 time0_n=1;
 for t=1:10, % read 10 files
  filename=[result_path time0(time0_n*11-10:time0_n*11)];
  eval(['load ' filename]);
  ref_alt0=height_arr1;
  if pulse=='LP' ref_alt0=height_arr2; end
  [del_alt,j]=min(abs(ref_alt0-put_alt)); put_alt0=ref_alt0(j);
  ref_alt_s0=ref_alt0(find(ref_alt0<=put_alt0 & ref_alt0>=MIN_alt));
  ref_alt_e0=ref_alt0(find(ref_alt0<=MAX_alt & ref_alt0>put_alt0));
  if length(ref_alt_s0)>length(ref_alt_s) ref_alt_s=ref_alt_s0; end
  if length(ref_alt_e0)>length(ref_alt_e) ref_alt_e=ref_alt_e0; end
  time0_n=time0_n+1;
 end % for t=1:10
 put_alt00=zeros(0);
 if pulse=='LP' & ref_alt_e(1)-ref_alt_s(length(ref_alt_s)) < (ref_alt_s(length(ref_alt_s))-ref_alt_s(length(ref_alt_s)-1))/4
  ref_alt_s=ref_alt_s(1:length(ref_alt_s)-1); % over estimate
  put_alt00=ref_alt_s(length(ref_alt_s));
 end
 ref_alt=[ref_alt_s(1:length(ref_alt_s)) ref_alt_e];
 ref_alt2=[ref_alt_s(1:length(ref_alt_s)-1) put_alt ref_alt_e]; % for display 
end

longitudinal=length(ref_alt);
num=length(time0)/11;	% total time unit numbers
paper=fix(num/10);	% full paper numbers
rest=rem(num,10);	% rest numbers
if rest~=0, paper2=paper+1; else paper2=paper; end 

ii=sqrt(-1);
time0_n=1;

for g=1:paper2   % paper numbers
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(['page = ' num2str(g) ' of ' num2str(paper2) '\n']);
pagenumber=['Page = ' num2str(g)];
if rest~=0 & g==paper2 transversal=rest;
else transversal=10; end

for i=1:transversal   % transversal
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filename=[result_path time0(time0_n*11-10:time0_n*11)];
file00=time0(time0_n*11-7:time0_n*11);
if i==1', file000=file00; end

eval(['load ' filename]);
time0_n=time0_n+1;
if i==1 d_time0=d_time; end   % title

if line_alt=='0',
 if pulse=='LP' 
  height_arr=height_arr2;
  status=status2;
  sig_r_arr=sig_r_arr2;
  sig_i_arr=sig_i_arr2;
  err_r_arr=err_r_arr2;
  err_i_arr=err_i_arr2;
  fitted_r_arr=fitted_r_arr2;
  fitted_i_arr=fitted_i_arr2;
 else
  height_arr=height_arr1;
  status=status1;
  sig_r_arr=sig_r_arr1;
  sig_i_arr=sig_i_arr1;
  err_r_arr=err_r_arr1;
  err_i_arr=err_i_arr1;
  fitted_r_arr=fitted_r_arr1;
  fitted_i_arr=fitted_i_arr1;
 end
 [del_alt,j]=min(abs(height_arr-put_alt)); put_alt0=height_arr(j);
 fitalt2s=find(height_arr<=put_alt0 & height_arr>=MIN_alt);
 fitalt2e=find(height_arr<=MAX_alt & height_arr>put_alt0);
 if length(fitalt2s)>length(ref_alt_s)
  del_alt=length(fitalt2s)-length(ref_alt_s);
  fitalt2s=fitalt2s(1+del_alt:length(fitalt2s));
 end
 if length(fitalt2e)>length(ref_alt_e)
  fitalt2e=fitalt2e(1:length(ref_alt_e)); end
 fitalt2=[fitalt2s fitalt2e];
 longitudinal2=length(fitalt2);
 height_arr=height_arr(fitalt2);
 status=status(fitalt2);
 sig_r_arr=sig_r_arr(:,fitalt2);
 sig_i_arr=sig_i_arr(:,fitalt2);
 err_r_arr=err_r_arr(:,fitalt2);
 err_i_arr=err_i_arr(:,fitalt2);
 fitted_r_arr=fitted_r_arr(:,fitalt2);
 fitted_i_arr=fitted_i_arr(:,fitalt2);
 jj_arrs=1+length(ref_alt_s)-length(fitalt2s);
 jj_arre=length(ref_alt_s)+length(fitalt2e);
 jj_arr=linspace(1,longitudinal,longitudinal);
 jj_arr=jj_arr(jj_arrs:jj_arre);
end % line_alt=='0'

if line_alt=='1',
 longitudinal2=longitudinal;
 if pulse=='LP' 
  height_arr=height_arr2(:,fitalt);
  status=status2(:,fitalt);
  sig_r_arr=sig_r_arr2(:,fitalt);
  sig_i_arr=sig_i_arr2(:,fitalt);
  err_r_arr=err_r_arr2(:,fitalt);
  err_i_arr=err_i_arr2(:,fitalt);
  fitted_r_arr=fitted_r_arr2(:,fitalt);
  fitted_i_arr=fitted_i_arr2(:,fitalt);
 else
  height_arr=height_arr1(:,fitalt);
  status=status1(:,fitalt);
  sig_r_arr=sig_r_arr1(:,fitalt);
  sig_i_arr=sig_i_arr1(:,fitalt);
  err_r_arr=err_r_arr1(:,fitalt);
  err_i_arr=err_i_arr1(:,fitalt);
  fitted_r_arr=fitted_r_arr1(:,fitalt);
  fitted_i_arr=fitted_i_arr1(:,fitalt);
 end
end

for j=1:longitudinal2   % longitudinal (tate)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%********************** FFT (FITTING DATA) *************************

t=length(sig_r_arr(:,j));
for n=2:t
 rdata=sig_r_arr(t+1-n,j);   % t-1 -> 1
 idata=-sig_i_arr(t+1-n,j);
 data1(n-1,1)=rdata+ii*idata;   % 1 -> t-1
end
for n=1:t
 rdata=sig_r_arr(n,j);
 idata=sig_i_arr(n,j);
 data1(t-1+n,1)=rdata+ii*idata;   % t -> 2t-1
end
num=2*t-1;
YY=fft(data1,num);
Y=fftshift(YY);
%pyy=Y.*conj(Y);
pyy=sqrt(Y.*conj(Y));

%********************** FFT (SIGNAL DATA) **************************

for n=2:t
 rdata=fitted_r_arr(t+1-n,j);   % t-1 -> 1
 idata=-fitted_i_arr(t+1-n,j);
 data1(n-1,1)=rdata+ii*idata;   % 1 -> t-1
end
for n=1:t
 rdata=fitted_r_arr(n,j);
 idata=fitted_i_arr(n,j);
 data1(t-1+n,1)=rdata+ii*idata;   % t -> 2t-1
end
YYf=fft(data1,num);
Yf=fftshift(YYf);
%pyyf=Yf.*conj(Yf);
pyyf=sqrt(Yf.*conj(Yf));

%********************** PLOT FRAME *********************************

axis('off');
axis([-20000 380000 0 3000000*(longitudinal+1)]);

hold on;

if i==1 & j==1,
 for i2=1:10-1   % transversal (yoko)
  for j2=2:longitudinal   % longitudinal (tate)
   plot([20000+40000*(i2-1) 20000+40000*(i2-1)],[0 3000000*longitudinal],'g');
   plot([-20000 380000],[3000000*(j2-1) 3000000*(j2-1)],'k:');
  end
 end
 for i2=1:10   % longitudinal (tate)
  plot([40000*(i2-1) 40000*(i2-1)],[0 3000000*longitudinal],'k:');
 end
 plot([20000+40000*(-1) 20000+40000*(-1)],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[3000000*longitudinal 3000000*longitudinal],'k');
 plot([380000 380000],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[0 0],'k');
end

%********************** PLOT SPECTRA *******************************

if j==1 last_jj=0; end
if line_alt=='1'|longitudinal2==longitudinal
 jj=j;
else 
 jj=jj_arr(j);
 [del_alt,jj1]=min(abs(ref_alt-height_arr(j)));

 if jj<=jj0 & jj1<jj & jj1>last_jj, jj=jj1; end
 if jj>=jj0 & jj1>jj & jj1>last_jj, jj=jj1; end
end
if jj<=last_jj, 
 if last_jj>=longitudinal,break;
 else jj=last_jj+1;end
end 
last_jj=jj;

smax=max(pyy);
fmax=max(pyyf);
if disp_data=='0' pmax=max(smax,fmax); end
if disp_data=='1' pmax=smax; end
if disp_data=='2' pmax=fmax; end
pm=3000000/pmax*0.7;
pma=pmax/scale;
ppm=int2str(pma);
if site=='UHF' f=1000000/15*(-t+1:t-1)/(2*t-1); end   % for UHF 
if site=='VHF' f=1000000/15*(-t+1:t-1)/(2*t-1); end   % for VHF
% A/D conversion (receiver of UHF and VHF radar) is 1 or 0.5 MHz.

if site=='UHF'
 if disp_data~='2' line1=plot(f(t-9:t+9)+40000*(i-1),pyy(t-9:t+9)*pm+3000000*(jj-1)); end
 if disp_data~='1' line2=plot(f(t-9:t+9)+40000*(i-1),pyyf(t-9:t+9)*pm+3000000*(jj-1),'r');  end
end
if site=='VHF'
 if disp_data~='2' line1=plot(f+40000*(i-1),pyy*pm+3000000*(jj-1)); end
 if disp_data~='1' line2=plot(f+40000*(i-1),pyyf*pm+3000000*(jj-1),'r');  end
end
if disp_data~='1' set(line2, 'linewidth', 1.0); end
tex=text(20000+40000*(i-1)-600,3000000*(jj-1)+3000000*0.80,ppm);
set(tex,'HorizontalAlignment','right');
set(tex,'FontSize',8);

%********************** OUTPUT HEIGHT ******************************

if line_alt=='0' & i==1 & j==1,
 for j2=1:longitudinal
  alt1=[int2str(fix(ref_alt2(j2))) ' km'];
  tex3=text(8000+20000*(-1-1),3000000*(j2-1)+3000000*0.5,alt1);
  set(tex3,'HorizontalAlignment','center');
 end
end
if line_alt=='1' & i==1,
 alt1=[int2str(fix(height_arr(j))) ' km'];
 tex3=text(8000+20000*(-1-1),3000000*(jj-1)+3000000*0.5,alt1);
 set(tex3,'HorizontalAlignment','center');
end

if disp_alt=='1',
 if j==1|j==length(height_arr),
  alt1=int2str(fix(height_arr(j)));
  tex3=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.5,alt1);
  set(tex3,'HorizontalAlignment','left');
  set(tex3,'FontSize',7);
 end
end
if disp_alt=='2',
 alt1=int2str(fix(height_arr(j)));
 tex3=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.5,alt1);
 set(tex3,'HorizontalAlignment','left');
 set(tex3,'FontSize',7);
end

%********************** OUTPUT QUALITY *****************************

if disp_q=='2'|(disp_q=='1' & rem(status(j),2^5)~=0),
 q1=int2str(fix(rem(status(j),2^5)));
 tex4=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.8,q1);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
end

if rem(status(j),2^5)==0 & status(j)>=2^5 & disp_q~='0',
 q2=' i';
 tex4=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.8,q2);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for j=1:longitudinal

%********************** START TIME *********************************

if round(d_time(7))<10 time2=int2str(d_time(7));time2=['0' time2];
else time2=int2str(d_time(7)); end
if round(d_time(9))<10 time3=int2str(d_time(9));time3=['0' time3];
else time3=int2str(d_time(9)); end
if round(d_time(11))<10 time4=int2str(d_time(11));time4=['0' time4];
else time4=int2str(d_time(11)); end
time30=[time2 ':' time3 ':' time4];   % for sec
tex2=text(40000*(i-1),(3000000*longitudinal)*1.015,time30);
set(tex2,'HorizontalAlignment','center');

%********************** END TIME ***********************************

if round(d_time(8))<10 time22=int2str(d_time(8));time22=['0' time22];
else time22=int2str(d_time(8)); end
if round(d_time(10))<10 time33=int2str(d_time(10));time33=['0' time33];
else time33=int2str(d_time(10)); end
if round(d_time(12))<10 time44=int2str(d_time(12));time44=['0' time44];
else time44=int2str(d_time(12)); end
time303=[time22 ':' time33 ':' time44];   % for sec
tex22=text(40000*(i-1),(3000000*longitudinal)*1.035,time303);
set(tex22,'HorizontalAlignment','center');

%********************** ACF FILE ***********************************

if disp_file=='1'
 tex2=text(40000*(i-1),(3000000*longitudinal)*1.062,file00);
 set(tex2,'HorizontalAlignment','center');
 set(tex2,'FontSize',9);
end

%********************** SYSTEM *************************************

if disp_sys=='1' & exist('r_Tsys'),
 if ~finite(r_Tsys)|r_Tsys>9999|r_Tsys<-1
  r_Tsys=-1;
 end % error:something wrong
 tex2=[num2str(sprintf('%5.0f',r_Tsys))];
 tex2=[tex2 ',' num2str(sprintf('%5.0f',r_Pt/1000))];
 tex2=['(' tex2 ')'];
 tex2=text(40000*(i-1),0-(3000000*longitudinal)*0.015,tex2);
 set(tex2,'HorizontalAlignment','center');
 set(tex2,'FontSize',7);
% if (r_Tsys<0|r_Tsys>250) set(tex2,'Color','r');end
% if ((r_Pt/1000)<100) set(tex2,'Color','b');end
end

%********************** BEAM ***************************************

if disp_beam=='1'
 tex2=[num2str(sprintf('%6.1f',r_az))];
 tex2=[tex2 ',' num2str(sprintf('%6.1f',r_el))];
 tex2=['(' tex2 ')'];
 tex2=text(40000*(i-1),0-(3000000*longitudinal)*0.035,tex2);
 set(tex2,'HorizontalAlignment','center');
 set(tex2,'FontSize',7);
end

%********************** PS_FILE NAME **********************************

if i==1,
 yy=int2str(rem(d_time(1),100));
 if round(d_time(1))<10 yy=['0' yy]; end
 mm=int2str(d_time(3));
 if round(d_time(3))<10 mm=['0' mm]; end
 dd=int2str(d_time(5));
 if round(d_time(5))<10 dd=['0' dd]; end
 nn=int2str(g);
 if g < 10 nn=['0' nn]; end
 filename2=[time2 time3 time4];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for i=1:transversal

%********************** TITLE **************************************

if round(d_time0(3))<10 timeM=int2str(d_time0(3));timeM=['0' timeM];
else timeM=int2str(d_time0(3)); end
if round(d_time0(5))<10 timeD=int2str(d_time0(5));timeD=['0' timeD];
else timeD=int2str(d_time0(5)); end
title0=[int2str(d_time0(1)) timeM timeD]; 
title0=[title0 '  ' title]; 
tex5=text(40000*(5.5-1),(3000000*longitudinal)*1.10,title0);
set(tex5,'FontName','times');
set(tex5,'HorizontalAlignment','center');
set(tex5,'FontSize',15);

%********************** COMMENT ************************************

tex5=text(-20000,-(3000000*longitudinal)*0.06,comment);
set(tex5,'HorizontalAlignment','left');

%********************** PATH ***************************************

if disp_path=='1',
 result_path2=result_path;  % print
 aa=find(result_path2 == '_');
 if ~isempty(aa)
  for k=1:length(aa)
   result_path2=[result_path2(1:aa(k)-1+(k-1)) '\' result_path2(aa(k)+(k-1):length(result_path2))];
  end % for k=1:length(aa)
  tex5=text(-20000,-(3000000*longitudinal)*0.085,['Data from ' result_path2]);
  set(tex5,'HorizontalAlignment','left');
 end
end

%********************** ACF FILE ***********************************

if disp_file=='1'
 a=['ACF file from acf' file000 '.mat to acf' file00 '.mat'];
 tex5=text(-20000,-(3000000*longitudinal)*0.11,a);
 set(tex5,'HorizontalAlignment','left');
end

%********************** SCALE **************************************

if scale~=1,
 tex10=['Power (x' int2str(scale) ')'];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.06,tex10);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** DATE ***************************************

if disp_date=='1'
 tex10=['Made on  ' date];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.085,tex10);  
 set(tex10,'HorizontalAlignment','right');
end
 
%********************** PAGE ***************************************

if disp_page=='1'
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.11,pagenumber);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** FREQENCY ***********************************

%tex10=text(40000*(10-1)-8000,-3000000*0.3,' x 30 kHz ');
%set(tex10,'HorizontalAlignment','left');

hold off;

%********************** PRINT FIGURES ******************************

set(gcf,'PaperOrientation','landscape');
set(gcf,'PaperPosition',[0.25 0.25 11.1929 7.76772]);
set(gcf,'PaperPositionMode','manual');
set(gcf,'PaperType','a4letter');
if PS_file=='2'|PS_file=='4' set(gcf,'Visible','off'); end
if PS_file=='0'
 pause;
end
if PS_file=='1'|PS_file=='2'
 if g==1 & site=='UHF',
  filename3=['spect' yy mm dd '_' filename2 '_' pulse '_' kst]; end
 if g==1 & site=='VHF',
  filename3=['spect' yy mm dd '_' filename2 '_' kst]; end
 if g==1 eval(['print  -dpsc2 ' filename3]);
  fprintf(['print ' filename3 '.ps\n']);
 else eval(['print -dpsc2 -append ' filename3]); end % append
end
if PS_file=='3'|PS_file=='4'
 if site=='UHF' filename2=['spect' yy mm dd '_' filename2 '_' pulse '_' kst]; end
 if site~='UHF' filename2=['spect' yy mm dd '_' filename2 '_' kst]; end
 eval(['print -dpsc2 ' filename2]);
 fprintf(['print ' filename2 '.ps\n']);
end
close;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for g=1:paper2
