%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                    %
%                                                                    %
%    ####   #####   ######   ####    #####  #####   #    #  #    #   %
%   #       #    #  #       #    #     #    #    #  #    #  ##  ##   %
%    ####   #    #  #####   #          #    #    #  #    #  # ## #   %
%        #  #####   #       #          #    #####   #    #  #    #   %
%   #    #  #       #       #    #     #    #   #   #    #  #    #   %
%    ####   #       ######   ####      #    #    #   ####   #    #   %
%                                                                    %
%   for ESR system                                                   %
%                                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;clear all;
global result_path plot_start plot_end
global site pulse MIN_alt MAX_alt channel
global line_alt disp_alt disp_data disp_q disp_beam disp_sys
global disp_file disp_path disp_date disp_page PS_file
global title comment scale put_alt
config_spectrum_ESR;

for i=1:2
 if i==1 time=plot_start; end
 if i==2 time=plot_end; end
 yd=365;
 if time(2)==1|time(2)==2 dif=0; end
 if time(2)==3|time(2)==4 dif=3; end
 if time(2)==5|time(2)==6 dif=4; end
 if time(2)==7|time(2)==8|plot_start(2)==9 dif=5; end
 if time(2)==10|time(2)==11 dif=6; end
 if time(2)==12 dif=7; end
 if rem(time(1),4)==0, % leap year
  yd=366;
  if time(2)>=3 dif=dif-1; end
 end
 ddd=(time(2)-1)*31+time(3)-dif; % 1<ddd<366
 if i==1, start_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
 if i==2,  end_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
end % for i=1:2

fid=fopen([result_path 'filelist_acf.dat'],'r');
time0=fscanf(fid,'%s');
status=fclose(fid);

time1=zeros(1,length(time0)/11);
for i=1:length(time0)/11
 time1(1,i)=str2num(time0(i*11-7:i*11));
end
fitarr=find(time1>start_sec & time1<=end_sec);
if length(fitarr)==0
 fprintf(['******  PLEASE CHECK "plot_start" & "plot_end"  ******\n']);
end
time0=time0(fitarr(1)*11-10:fitarr(length(fitarr))*11);
time1=time1(fitarr);

filename=[result_path time0(1:11)];   % ex. acf04111260
eval(['load ' filename]);

if disp_data=='1' & channel~=0, % only signal data -> change fitted data (for gup0)
 altfarr=zeros(0);r_acff=zeros(0);r_acff=zeros(0);
 if channel==1,altfarr=alt1arr;r_acff=r_acf1;i_acff=i_acf1;end
 if channel==2,altfarr=alt2arr;r_acff=r_acf2;i_acff=i_acf2;end
 if channel==3,altfarr=alt3arr;r_acff=r_acf3;i_acff=i_acf3;end
 if channel==4,altfarr=alt4arr;r_acff=r_acf4;i_acff=i_acf4;end
 if channel==5,altfarr=alt5arr;r_acff=r_acf5;i_acff=i_acf5;end
 if channel==6,altfarr=alt6arr;r_acff=r_acf6;i_acff=i_acf6;end
 if channel==7,altfarr=alt7arr;r_acff=r_acf7;i_acff=i_acf7;end
 if channel==8,altfarr=alt8arr;r_acff=r_acf8;i_acff=i_acf8;end
end

height_arr=altfarr;
fitalt=find(height_arr<=MAX_alt & height_arr>=MIN_alt);
if length(fitalt)==0
	fprintf(['******  PLEASE CHECK "MIN_alt" & "MAX_alt"  ******\n']);
end
ref_alt=height_arr(fitalt);

if line_alt=='0', % alt
 [del_alt,jj0]=min(abs(ref_alt-put_alt)); put_alt0=ref_alt(jj0);
  ref_alt_s=height_arr(find(height_arr<=put_alt0 & height_arr>=MIN_alt));
  ref_alt_e=height_arr(find(height_arr<=MAX_alt & height_arr>put_alt0));
 time0_n=1;
 for t=1:10, % read 10 files
  filename=[result_path time0(time0_n*11-10:time0_n*11)];
  eval(['load ' filename]);
  ref_alt0=altfarr;
  [del_alt,j]=min(abs(ref_alt0-put_alt)); put_alt0=ref_alt0(j);
  ref_alt_s0=ref_alt0(find(ref_alt0<=put_alt0 & ref_alt0>=MIN_alt));
  ref_alt_e0=ref_alt0(find(ref_alt0<=MAX_alt & ref_alt0>put_alt0));
  if length(ref_alt_s0)>length(ref_alt_s),ref_alt_s=ref_alt_s0; end
  if length(ref_alt_e0)>length(ref_alt_e),ref_alt_e=ref_alt_e0; end
  time0_n=time0_n+1;
 end % for t=1:10

 put_alt00=zeros(0);
 if pulse=='LP' & ref_alt_e(1)-ref_alt_s(length(ref_alt_s)) < (ref_alt_s(length(ref_alt_s))-ref_alt_s(length(ref_alt_s)-1))/4
  ref_alt_s=ref_alt_s(1:length(ref_alt_s)-1); % over estimate
  put_alt00=ref_alt_s(length(ref_alt_s));
 end
 ref_alt=[ref_alt_s(1:length(ref_alt_s)) ref_alt_e];
 ref_alt2=[ref_alt_s(1:length(ref_alt_s)-1) put_alt ref_alt_e]; % for display 
end

longitudinal=length(ref_alt);
num=length(time0)/11;                 % Total time unit numbers
paper=fix(num/10);                    % Full paper numbers
rest=rem(num,10);                     % Rest numbers
if rest~=0, paper2=paper+1;else paper2=paper;end    

ii=sqrt(-1);
time0_n=1;

for g=1:paper2      %  paper numbers
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf(['page = ' num2str(g) ' of ' num2str(paper2) '\n']);
pagenumber=['Page = ' num2str(g)];
if rest ~= 0 & g == paper2, 
 transversal=rest;
else 
 transversal=10;
end

for i=1:transversal;        %  transversal (last)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filename=[result_path time0(time0_n*11-10:time0_n*11)];
file00=time0(time0_n*11-7:time0_n*11);
if i==1', file000=file00; end

eval(['load ' filename]);
time0_n=time0_n+1;
if i==1 d_time0=d_time; end   % title

if disp_data=='1' & channel~=0, % only signal data -> change fitted data (for gup0)
 altfarr=zeros(0);r_acff=zeros(0);r_acff=zeros(0);
 if channel==1,altfarr=alt1arr;r_acff=r_acf1;i_acff=i_acf1;end
 if channel==2,altfarr=alt2arr;r_acff=r_acf2;i_acff=i_acf2;end
 if channel==3,altfarr=alt3arr;r_acff=r_acf3;i_acff=i_acf3;end
 if channel==4,altfarr=alt4arr;r_acff=r_acf4;i_acff=i_acf4;end
 if channel==5,altfarr=alt5arr;r_acff=r_acf5;i_acff=i_acf5;end
 if channel==6,altfarr=alt6arr;r_acff=r_acf6;i_acff=i_acf6;end
 if channel==7,altfarr=alt7arr;r_acff=r_acf7;i_acff=i_acf7;end
 if channel==8,altfarr=alt8arr;r_acff=r_acf8;i_acff=i_acf8;end
end

if line_alt=='0', % for alt
 height_arr=altfarr;
 if pulse~='LP'| isempty(put_alt00)
 [del_alt,j]=min(abs(height_arr-put_alt)); put_alt0=height_arr(j);
 fitalt2s=find(height_arr<=put_alt0 & height_arr>=MIN_alt);
 fitalt2e=find(height_arr<=MAX_alt & height_arr>put_alt0);
 else %if pulse=='LP'& ~isempty(put_alt00)
 [del_alt,j]=min(abs(height_arr-put_alt00)); put_alt01=height_arr(j);
 fitalt2s=find(height_arr<=put_alt01 & height_arr>=MIN_alt);
 fitalt2e=find(height_arr<=MAX_alt & height_arr>put_alt01);
 end
 if length(fitalt2s)>length(ref_alt_s)
  del_alt=length(fitalt2s)-length(ref_alt_s);
  fitalt2s=fitalt2s(1+del_alt:length(fitalt2s));
 end
 if length(fitalt2e)>length(ref_alt_e)
  fitalt2e=fitalt2e(1:length(ref_alt_e)); 
 end
 fitalt2=[fitalt2s fitalt2e];
 longitudinal2=length(fitalt2);
 height_arr=altfarr(fitalt2);
 status=status1(fitalt2); 
 fitted_r_arr=r_acff(:,fitalt2);
 fitted_i_arr=i_acff(:,fitalt2);
 jj_arrs=1+length(ref_alt_s)-length(fitalt2s);
 jj_arre=length(ref_alt_s)+length(fitalt2e);
 jj_arr=linspace(1,longitudinal,longitudinal);
 jj_arr=jj_arr(jj_arrs:jj_arre);
end % line_alt=='0'

if line_alt=='1',
 longitudinal2=longitudinal;
 fitalt2=fitalt;
 height_arr=altfarr(fitalt2);
 status=status1(fitalt2); 
 fitted_r_arr=r_acff(:,fitalt2);
 fitted_i_arr=i_acff(:,fitalt2);
end % line_alt=='1'

for j=1:longitudinal2 %  longitudinal
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if channel==1,height_arr3=alt1arr;end
if channel==2,height_arr3=alt2arr;end
if channel==3,height_arr3=alt3arr;end
if channel==4,height_arr3=alt4arr;end
if channel==5,height_arr3=alt5arr;end
if channel==6,height_arr3=alt6arr;end
if channel==7,height_arr3=alt7arr;end
if channel==8,height_arr3=alt8arr;end
if channel~=0,
 fitalt3=find(height_arr3==altfarr(fitalt2(j)));
 if ~isempty(fitalt3)
  if channel==1,sig_r_arr(:,j)=r_acf1(:,fitalt3);sig_i_arr(:,j)=i_acf1(:,fitalt3);end
  if channel==2,sig_r_arr(:,j)=r_acf2(:,fitalt3);sig_i_arr(:,j)=i_acf2(:,fitalt3);end
  if channel==3,sig_r_arr(:,j)=r_acf3(:,fitalt3);sig_i_arr(:,j)=i_acf3(:,fitalt3);end
  if channel==4,sig_r_arr(:,j)=r_acf4(:,fitalt3);sig_i_arr(:,j)=i_acf4(:,fitalt3);end
  if channel==5,sig_r_arr(:,j)=r_acf5(:,fitalt3);sig_i_arr(:,j)=i_acf5(:,fitalt3);end
  if channel==6,sig_r_arr(:,j)=r_acf6(:,fitalt3);sig_i_arr(:,j)=i_acf6(:,fitalt3);end
  if channel==7,sig_r_arr(:,j)=r_acf7(:,fitalt3);sig_i_arr(:,j)=i_acf7(:,fitalt3);end
  if channel==8,sig_r_arr(:,j)=r_acf8(:,fitalt3);sig_i_arr(:,j)=i_acf8(:,fitalt3);end
 end % ~isempty(fitalt3)
end % if channel~=0


if channel==0,  % make average
 ch=0;
 sig_r_arr00=fitted_r_arr*0;sig_i_arr00=fitted_r_arr*0;
 if exist('alt1arr'),fitalt00=find(alt1arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len1=min(length(r_acf1(:,1)),length(r_acff(:,1)));
 dat=find(r_acf1(1:min_len1,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf1(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf1(dat,fitalt00);end;end;
 if exist('alt2arr'),fitalt00=find(alt2arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len2=min(length(r_acf2(:,1)),length(r_acff(:,1)));
 dat=find(r_acf2(1:min_len2,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf2(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf2(dat,fitalt00);end;end
 if exist('alt3arr'),fitalt00=find(alt3arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len3=min(length(r_acf3(:,1)),length(r_acff(:,1)));
 dat=find(r_acf3(1:min_len3,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf3(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf3(dat,fitalt00);end;end
 if exist('alt4arr'),fitalt00=find(alt4arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len4=min(length(r_acf4(:,1)),length(r_acff(:,1)));
 dat=find(r_acf4(1:min_len4,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf4(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf4(dat,fitalt00);end;end
 if exist('alt5arr'),fitalt00=find(alt5arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len5=min(length(r_acf5(:,1)),length(r_acff(:,1)));
 dat=find(r_acf5(1:min_len5,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf5(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf5(dat,fitalt00);end;end
 if exist('alt6arr'),fitalt00=find(alt6arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len6=min(length(r_acf6(:,1)),length(r_acff(:,1)));
 dat=find(r_acf6(1:min_len6,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf6(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf6(dat,fitalt00);end;end
 if exist('alt7arr'),fitalt00=find(alt7arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len7=min(length(r_acf7(:,1)),length(r_acff(:,1)));
 dat=find(r_acf7(1:min_len7,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf7(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf7(dat,fitalt00);end;end
 if exist('alt8arr'),fitalt00=find(alt8arr==altfarr(fitalt2(j)));
 if ~isempty(fitalt00),min_len8=min(length(r_acf8(:,1)),length(r_acff(:,1)));
 dat=find(r_acf8(1:min_len8,fitalt00) ~= 0);
 sig_r_arr00(dat,j)=sig_r_arr00(dat,j)+r_acf8(dat,fitalt00);ch=ch+1;
 sig_i_arr00(dat,j)=sig_i_arr00(dat,j)+i_acf8(dat,fitalt00);end;end
 sig_r_arr=sig_r_arr00./ch; sig_i_arr=sig_i_arr00./ch;fitalt3=1;
end % if channel==0

%********************** FFT (FITTING DATA) *************************

dataf=zeros(0); %reset
t=length(fitted_r_arr(:,j));
for n=1:t-1
 rdata=fitted_r_arr(t+1-n,j);	%t ->  2
 idata=-fitted_i_arr(t+1-n,j);
 dataf(n,1)=rdata+ii*idata;    %1   ->  t-1
end
for n=1:t
 rdata=fitted_r_arr(n,j);
 idata=fitted_i_arr(n,j);
 dataf(t-1+n,1)=rdata+ii*idata;  %t   ->  2t-1
end
num=2*t-1;
YYf=fft(dataf,num);
Yf=fftshift(YYf);
pyyf=sqrt(Yf.*conj(Yf));

%********************** FFT (SIGNAL DATA) **************************

if ~isempty(fitalt3),
 ts=length(sig_r_arr(:,j));
 data1=zeros(0); %reset
 for n=1:ts-1
  rdata=sig_r_arr(ts+1-n,j);    %ts ->  2
  idata=-sig_i_arr(ts+1-n,j);
  data1(n,1)=rdata+ii*idata;    %1   ->  ts-1
 end
 for n=1:ts
  rdata=sig_r_arr(n,j);
  idata=sig_i_arr(n,j);
  data1(ts-1+n,1)=rdata+ii*idata;  %ts   ->  2ts-1
 end
 nums=2*ts-1;
 YY=fft(data1,nums);
 Y=fftshift(YY);
 pyy=sqrt(Y.*conj(Y));
end % if ~isempty(fitalt3)

%********************** PLOT FRAME *********************************

axis('off');
axis([-20000 380000 0 3000000*(longitudinal+1)]);

hold on;

if i==1 & j==1,
 for i2=1:10-1           %  transversal  (yoko)
  for j2=2:longitudinal %  longitudinal (tate)
   plot([20000+40000*(i2-1) 20000+40000*(i2-1)],[0 3000000*longitudinal],'g');
   plot([-20000 380000],[3000000*(j2-1) 3000000*(j2-1)],'k:');
  end
 end
 for i2=1:10 %  longitudinal (tate)
  plot([40000*(i2-1) 40000*(i2-1)],[0 3000000*longitudinal],'k:');
 end
 plot([20000+40000*(-1) 20000+40000*(-1)],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[3000000*longitudinal 3000000*longitudinal],'k');
 plot([380000 380000],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[0 0],'k');
end % if i==1 & j==1

%********************** PLOT SPECTRA *******************************

if j==1 last_jj=0; end
if line_alt=='1'|longitudinal2==longitudinal
 jj=j;
else 
 jj=jj_arr(j);
 [del_alt,jj1]=min(abs(ref_alt-height_arr(j)));
 if jj<=jj0 & jj1<jj & jj1>last_jj, jj=jj1; end
 if jj>=jj0 & jj1>jj & jj1>last_jj, jj=jj1; end
end
if jj<=last_jj, 
 if last_jj>=longitudinal,break;
 else jj=last_jj+1;end
end 
last_jj=jj;

fmax=max(pyyf); % fitted data always exist

if disp_data=='0', 
 if ~isempty(fitalt3),smax=max(pyy); pmax=max(smax,fmax);
 else,pmax=fmax; % omly fitted data
 end %~isempty(fitalt3)
end
if disp_data=='1',pmax=max(pyy); end
if disp_data=='2',pmax=fmax; end
pm=3000000/pmax*0.7;
pma=pmax/scale;  % change number
ppm=int2str(pma);

f=1000000/15*(-t+1:t-1)/(2*t-1); 
if ~isempty(fitalt3),
 fs=1000000/15*(-ts+1:ts-1)/(2*ts-1);
end %~isempty(fitalt3)
% A/D conversion (receiver of UHF and VHF radar) is 1 or 0.5 MHz.
% A/D conversion (receiver of ESR ) is 10 MHz.

if pulse=='AC'
 if disp_data~='2' & ~isempty(fitalt3),
  if length(ts) >= 20,
  line1=plot(fs(ts-12:ts+12)+40000*(i-1),pyy(ts-12:ts+12)*pm+3000000*(jj-1));
  else, % if length(ts) < 20,
  h_ts=fix(ts/2);
  line1=plot(fs(ts-h_ts:ts+h_ts)+40000*(i-1),pyy(ts-h_ts:ts+h_ts)*pm+3000000*(jj-1));
  end
 end
 if disp_data~='1',line2=plot(f(t-12:t+12)+40000*(i-1),pyyf(t-12:t+12)*pm+3000000*(jj-1),'r'); end
end
if pulse=='LP'
 if disp_data~='2' & ~isempty(fitalt3),
  if length(ts) >= 20,
  line1=plot(fs(ts-9:ts+9)+40000*(i-1),pyy(ts-9:ts+9)*pm+3000000*(jj-1));
  else, % if length(ts) < 20,
  h_ts=fix(ts/2);
  line1=plot(fs(ts-h_ts:ts+h_ts)+40000*(i-1),pyy(ts-h_ts:ts+h_ts)*pm+3000000*(jj-1));
  end
 end
 if disp_data~='1', line2=plot(f(t-9:t+9)+40000*(i-1),pyyf(t-9:t+9)*pm+3000000*(jj-1),'r'); end
end
if disp_data~='1',set(line2, 'linewidth', 1.0); end
tex=text(20000+40000*(i-1)-600,3000000*(jj-1)+3000000*0.80,ppm);
set(tex,'HorizontalAlignment','right');
set(tex,'FontSize',8);

%********************** OUTPUT HEIGHT ******************************

if line_alt=='0' & i==1 & j==1,% alt
 for j2=1:longitudinal
  alt1=[int2str(round(ref_alt2(j2))) ' km'];
  tex3=text(8000+20000*(-1-1),3000000*(j2-1)+3000000*0.5,alt1);
  set(tex3,'HorizontalAlignment','center');
 end
end
if line_alt=='1' & i==1, % range
 alt1=[int2str(round(height_arr(j))) ' km'];
 tex3=text(8000+20000*(-1-1),3000000*(jj-1)+3000000*0.5,alt1);
 set(tex3,'HorizontalAlignment','center');
end
if disp_alt=='1',
 if j==1|j==length(height_arr),
  alt1=int2str(round(height_arr(j)));
  tex3=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.5,alt1);
  set(tex3,'HorizontalAlignment','left');
  set(tex3,'FontSize',7);
 end
end
if disp_alt=='2',
 alt1=int2str(round(height_arr(j)));
 tex3=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.5,alt1);
 set(tex3,'HorizontalAlignment','left');
 set(tex3,'FontSize',7);
end

%********************** OUTPUT QUALITY *****************************

if disp_q=='2'|(disp_q=='1' & rem(status(j),2^5)~=0),
 q1=int2str(fix(rem(status(j),2^5)));
 tex4=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.8,q1);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
 set(tex4,'FontSize',7);
end

if rem(status(j),2^5)==0 & status(j)>=2^5 & disp_q~='0',
 q2=' i';
 tex4=text(-20000+40000*(i-1)+600,3000000*(jj-1)+3000000*0.8,q2);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
 set(tex4,'FontSize',7);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end % for j:longitudinal

%sig_r_arr=zeros(0);sig_i_arr=zeros(0); % reset
%fitted_r_arr=zeros(0);fitted_i_arr=zeros(0); % reset
%err_r_arr=zeros(0);err_i_arr=zeros(0); % reset
%height_arr_label=height_arr;
%height_arr=zeros(0); % reset

%********************** START TIME *********************************

if round(d_time(7)) < 10 time2=int2str(d_time(7));time2=['0' time2];
else time2=int2str(d_time(7));end
if round(d_time(9)) < 10 time3=int2str(d_time(9));time3=['0' time3];
else time3=int2str(d_time(9));end
if round(d_time(11)) < 10 time4=int2str(d_time(11));time4=['0' time4];
else time4=int2str(d_time(11));end
time30=[time2 ':' time3 ':' time4];   % for sec
tex2=text(40000*(i-1),(3000000*longitudinal)*1.015,time30);
set(tex2,'HorizontalAlignment','center');

%********************** END TIME ***********************************

if round(d_time(8)) < 10 time22=int2str(d_time(8));time22=['0' time22];
else time22=int2str(d_time(8));end
if round(d_time(10)) < 10 time33=int2str(d_time(10));time33=['0' time33];
else time33=int2str(d_time(10));end
if round(d_time(12)) < 10 time44=int2str(d_time(12));time44=['0' time44];
else time44=int2str(d_time(12));end
time303=[time22 ':' time33 ':' time44];   % for sec
tex22=text(40000*(i-1),(3000000*longitudinal)*1.035,time303);
set(tex22,'HorizontalAlignment','center');

%********************** ACF FILE ***********************************

if disp_file=='1' % name of acf file
 tex222=text(40000*(i-1),(3000000*longitudinal)*1.062,file00);
 set(tex222,'HorizontalAlignment','center');
 set(tex222,'FontSize',9);
end

%********************** SYSTEM *************************************

if disp_sys=='1' & exist('r_Tsys'),
 if ~finite(r_Tsys)|r_Tsys>9999|r_Tsys<-1
  r_Tsys=-1;
 end % error:something wrong
 tex2=[num2str(sprintf('%5.0f',r_Tsys))];
 tex2=[tex2 ',' num2str(sprintf('%5.0f',r_Pt/1000))];
 tex2=['(' tex2 ')'];
 tex2=text(40000*(i-1),0-(3000000*longitudinal)*0.015,tex2);
 set(tex2,'HorizontalAlignment','center');
 set(tex2,'FontSize',7);
% if (r_Tsys<0|r_Tsys>250) set(tex2,'Color','r');end
% if ((r_Pt/1000)<100) set(tex2,'Color','b');end
end

%********************** BEAM ***************************************

if disp_beam=='1'
 tex2=[num2str(sprintf('%6.1f',r_az))];
 tex2=[tex2 ',' num2str(sprintf('%6.1f',r_el))];
 tex2=['(' tex2 ')'];
 tex2=text(40000*(i-1),0-(3000000*longitudinal)*0.035,tex2);
 set(tex2,'HorizontalAlignment','center');
 set(tex2,'FontSize',7);
end

%********************** PS_FILE NAME **********************************

if i==1,
 yy=int2str(rem(d_time(1),100));
 if round(rem(d_time(1),100)) < 10 yy=['0' yy];end
 mm=int2str(d_time(3));
 if round(d_time(3)) < 10 mm=['0' mm];end
 dd=int2str(d_time(5));
 if round(d_time(5)) < 10 dd=['0' dd];end
 nn=int2str(g);
 if g < 10 nn=['0' nn];end
 filename2=[time2 time3 time4];
end

%*******************************************************************

if i==1 d_time0=d_time; end   % title

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end % for i:transversal

%********************** TITLE **************************************

if round(d_time(3)) < 10 timeM=int2str(d_time(3));timeM=['0' timeM];
else timeM=int2str(d_time(3));end
if round(d_time(5)) < 10 timeD=int2str(d_time(5));timeD=['0' timeD];
else timeD=int2str(d_time(5));end
title0=[int2str(d_time0(1)) timeM timeD]; 
title0=[title0 '  ' title]; 
tex5=text(40000*(5.5-1),(3000000*longitudinal)*1.10,title0);
set(tex5,'FontName','times');
set(tex5,'HorizontalAlignment','center');
set(tex5,'FontSize',15);

%********************** COMMENT ************************************

tex5=text(-20000,-(3000000*longitudinal)*0.06,comment);
set(tex5,'HorizontalAlignment','left');

%********************** PATH ***************************************

if disp_path=='1',
 result_path2=result_path;  % print
 aa=find(result_path2 == '_');
 if ~isempty(aa)
  for k=1:length(aa)
   result_path2=[result_path2(1:aa(k)-1+(k-1)) '\' result_path2(aa(k)+(k-1):length(result_path2))];
  end % for k=1:length(aa)
  tex5=text(-20000,-(3000000*longitudinal)*0.085,['Data from ' result_path2]);
  set(tex5,'HorizontalAlignment','left');
 end
end

%********************** ACF FILE ***********************************

if disp_file=='1'
 a=['ACF file from acf' file000 '.mat to acf' file00 '.mat'];
 tex5=text(-20000,-(3000000*longitudinal)*0.11,a);
 set(tex5,'HorizontalAlignment','left');
end

%********************** SCALE **************************************

if scale~=1,
 tex10=['Power (x' num2str(scale) ')'];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.06,tex10);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** DATE ***************************************

if disp_date=='1'
 tex10=['Made on  ' date];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.085,tex10);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** PAGE ***************************************

if disp_page=='1'
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.11,pagenumber);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** FREQENCY ***********************************

%tex10=text(40000*(10-1)-8000,-(3000000*longitudinal)*0.135,' x  30 kHz ');  
%set(tex10,'HorizontalAlignment','left');

hold off;

%********************** PRINT FIGURES ******************************

set(gcf,'PaperOrientation','landscape');
set(gcf,'PaperPosition',[0.25 0.25 11.1929 7.76772]);
set(gcf,'PaperPositionMode','manual');
set(gcf,'PaperType','a4letter');
if PS_file=='2'|PS_file=='4'|PS_file=='5' set(gcf,'Visible','off'); end
if PS_file=='0',pause;end
if PS_file=='1'|PS_file=='2'
 if g==1
  filename3=['spect' yy mm dd '_' filename2 '_' pulse '_' site];
  eval(['print  -dpsc2 ' filename3]);
  fprintf(['print ' filename3 '.ps\n']);
 else  
  eval(['print  -dpsc2 -append ' filename3]); % append
 end 
end
if PS_file=='3'|PS_file=='4'
 filename3=['spect' yy mm dd '_' filename2 '_' pulse '_' site]; 
 eval(['print -dpsc2 ' filename3]);
 fprintf(['print ' filename3 '.ps\n']);
end
if PS_file=='5'
 if channel==0, 
  chan='ALL';
 else 
  chan=int2str(channel);
 end
 if g==1
  filename3=['spect' yy mm dd '_' filename2 '_' pulse '_' site '_ch' chan];
  eval(['print  -dpsc2 ' filename3]);
  fprintf(['print ' filename3 '.ps\n']);
 else  
  eval(['print  -dpsc2 -append ' filename3]); % append
 end 
end
close;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end % for g:paper2
