%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                    %
%                                                                    %
%    ####   #####   ######   ####    #####  #####   #    #  #    #   %
%   #       #    #  #       #    #     #    #    #  #    #  ##  ##   %
%    ####   #    #  #####   #          #    #    #  #    #  # ## #   %
%        #  #####   #       #          #    #####   #    #  #    #   %
%   #    #  #       #       #    #     #    #   #   #    #  #    #   %
%    ####   #       ######   ####      #    #    #   ####   #    #   %
%                                                                    %
%   for Kiruna or Sodankyla system                                    %
%                                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close;clear;
close all;clear all;
global result_path plot_start plot_end
global kst pulse num_vert
global disp_alt disp_data disp_q 
global disp_file disp_path disp_date disp_page PS_file
global title comment scale
config_spectrum_KST_remote;

site='UHF';	%  only 'UHF'
line_alt='1';	%  '1': with ranges
MIN_alt=0;	%  lowest height [km] you wish to plot
MAX_alt=1000;	%  highest height [km] you wish to plot

for i=1:2
 if i==1 time=plot_start; end
 if i==2 time=plot_end; end
 yd=365;
 if time(2)==1|time(2)==2 dif=0; end
 if time(2)==3|time(2)==4 dif=3; end
 if time(2)==5|time(2)==6 dif=4; end
 if time(2)==7|time(2)==8|plot_start(2)==9 dif=5; end
 if time(2)==10|time(2)==11 dif=6; end
 if time(2)==12 dif=7; end
 if rem(time(1),4)==0, % leap year
  yd=366;
  if time(2)>=3 dif=dif-1; end
 end
 ddd=(time(2)-1)*31+time(3)-dif; % 1<ddd<366
 if i==1 start_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
 if i==2 end_sec=(ddd-1)*24*60*60+time(4)*60*60+time(5)*60+time(6); end
end % for i=1:2

fid=fopen([result_path 'filelist_acf.dat'],'r');
time0=fscanf(fid,'%s');
status=fclose(fid);

time1=zeros(1,length(time0)/11);
for i=1:length(time0)/11
 time1(1,i)=str2num(time0(i*11-7:i*11));
end
fitarr=find(time1>start_sec & time1<=end_sec);
if length(fitarr)==0
 fprintf(['******  PLEASE CHECK "plot_start" & "plot_end"  ******\n']);
end
time0=time0(fitarr(1)*11-10:fitarr(length(fitarr))*11);
time1=time1(fitarr);

filename=[result_path time0(1:11)];
eval(['load ' filename]);
height_arr=height_arr1;
if pulse=='LP' height_arr=height_arr2; end
fitalt=find(height_arr<=MAX_alt & height_arr>=MIN_alt);
%if length(fitalt)==0
% fprintf(['******  PLEASE CHECK "MIN_alt" & "MAX_alt"  ******\n']);
%end
longitudinal=num_vert;   % total heights

num=length(time0)/11;		% total time unit numbers
paper=fix(num/(10*num_vert));	% full paper numbers
rest=rem(num,10*num_vert);	% rest numbers
if rest~=0, paper2=paper+1; else paper2=paper; end    

ii=sqrt(-1);
time0_n=1;

for g=1:paper2   % paper numbers
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if rest~=0 & g==paper2 transversal=rest;
else transversal=10; end
fprintf(['page = ' num2str(g) ' of ' num2str(paper2) '\n']);
pagenumber=['Page = ' num2str(g)];

for i=1:transversal   % transversal (yoko)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for j=1:num_vert   % longitudinal (tate)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if (time0_n*11-10)>(length(time0)), break; end

filename=[result_path time0(time0_n*11-10:time0_n*11)];
file00=time0(time0_n*11-7:time0_n*11);
eval(['load ' filename]);
time0_n=time0_n+1;
if i==1 & j==1 d_time0=d_time; file000=file00; end   % title

%********************** START TIME & END TIME **********************

if round(d_time(7))<10 time2=int2str(d_time(7));time2=['0' time2];
else time2=int2str(d_time(7)); end
if round(d_time(9))<10 time3=int2str(d_time(9));time3=['0' time3];
else time3=int2str(d_time(9)); end
if round(d_time(11))<10 time4=int2str(d_time(11));time4=['0' time4];
else time4=int2str(d_time(11)); end
time30=[time2 ':' time3 ':' time4];   % for sec
if j==1,
 tex2=text(40000*(i-1),0-(3000000*longitudinal)*0.015,time30);
 set(tex2,'HorizontalAlignment','center');
end
if j==num_vert|(time0_n*11-10)>(length(time0)),
 tex2=text(40000*(i-1),(3000000*longitudinal)*1.015,time30);
 set(tex2,'HorizontalAlignment','center');
end

%********************** PS_FILE NAME *******************************

if i==1 & j==1,
 yy=int2str(rem(d_time(1),100));
 if round(d_time(1))<10 yy=['0' yy]; end
 mm=int2str(d_time(3));
 if round(d_time(3))<10 mm=['0' mm]; end
 dd=int2str(d_time(5));
 if round(d_time(5))<10 dd=['0' dd]; end
 nn=int2str(g);
 if g < 10 nn=['0' nn]; end
 filename2=[time2 time3 time4];
end

%********************** SORT ALTITUDE ******************************

if pulse=='LP'
 fitalt2=find(height_arr2<=MAX_alt & height_arr2>=MIN_alt);
 if length(fitalt2)<1, break; end
 longitudinal2=length(height_arr2(:,fitalt2(1)+(0:length(fitalt)-1)));
 height_arr=height_arr2(:,fitalt2(1));
 status=status2(:,fitalt2(1));
 sig_r_arr=sig_r_arr2(:,fitalt2(1));
 sig_i_arr=sig_i_arr2(:,fitalt2(1));
 err_r_arr=err_r_arr2(:,fitalt2(1));
 err_i_arr=err_i_arr2(:,fitalt2(1));
 fitted_r_arr=fitted_r_arr2(:,fitalt2(1));
 fitted_i_arr=fitted_i_arr2(:,fitalt2(1));
else
 fitalt2=find(height_arr1<=MAX_alt & height_arr1>=MIN_alt);
 if length(fitalt2)<1, break; end
 longitudinal2=length(height_arr1(:,fitalt2(1)));
 height_arr=height_arr1(:,fitalt2(1));
 status=status1(:,fitalt2(1));
 sig_r_arr=sig_r_arr1(:,fitalt2(1));
 sig_i_arr=sig_i_arr1(:,fitalt2(1));
 err_r_arr=err_r_arr1(:,fitalt2(1));
 err_i_arr=err_i_arr1(:,fitalt2(1));
 fitted_r_arr=fitted_r_arr1(:,fitalt2(1));
 fitted_i_arr=fitted_i_arr1(:,fitalt2(1));
end

%********************** FFT (SIGNAL DATA) **************************

jj=1;
t=length(sig_r_arr(:,jj));
for n=2:t
 rdata=sig_r_arr(t+1-n,jj);   % t-1 -> 1
 idata=-sig_i_arr(t+1-n,jj);
 data1(n-1,1)=rdata+ii*idata;   % 1 -> t-1
end
for n=1:t
 rdata=sig_r_arr(n,jj);
 idata=sig_i_arr(n,jj);
 data1(t-1+n,1)=rdata+ii*idata;   % t -> 2t-1
end
num=2*t-1;
YY=fft(data1,num);
Y=fftshift(YY);
%pyy=Y.*conj(Y);
pyy=sqrt(Y.*conj(Y));

%********************** FFT (FITTING DATA) *************************

jj=1;
for n=2:t
 rdata=fitted_r_arr(t+1-n,jj);   % t-1 -> 1
 idata=-fitted_i_arr(t+1-n,jj);
 data1(n-1,1)=rdata+ii*idata;   % 1 -> t-1
end
for n=1:t
 rdata=fitted_r_arr(n,jj);
 idata=fitted_i_arr(n,jj);
 data1(t-1+n,1)=rdata+ii*idata;   % t -> 2t-1
end
YYf=fft(data1,num);
Yf=fftshift(YYf);
%pyyf=Yf.*conj(Yf);
pyyf=sqrt(Yf.*conj(Yf));

%********************** PLOT FRAME *********************************

axis('off');
axis([-20000 380000 0 3000000*(longitudinal+1)]);

hold on;

if i==1 & j==1,
 for i2=1:10-1   % transversal (yoko)
  for j2=2:longitudinal   % longitudinal (tate)
   plot([20000+40000*(i2-1) 20000+40000*(i2-1)],[0 3000000*longitudinal],'g');
   plot([-20000 380000],[3000000*(j2-1) 3000000*(j2-1)],'k:');
  end
 end
 for i2=1:10   % longitudinal (tate)
  plot([40000*(i2-1) 40000*(i2-1)],[0 3000000*longitudinal],'k:');
 end
 plot([20000+40000*(-1) 20000+40000*(-1)],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[3000000*longitudinal 3000000*longitudinal],'k');
 plot([380000 380000],[0 3000000*longitudinal],'k');
 plot([-20000 380000],[0 0],'k');
end

%********************** PLOT SPECTRA *******************************

smax=max(pyy);
fmax=max(pyyf);
if disp_data=='0' pmax=max(smax,fmax); end
if disp_data=='1' pmax=smax; end
if disp_data=='2' pmax=fmax; end
pm=3000000/pmax*0.7;
pma=pmax/scale;
ppm=int2str(pma);
if site=='UHF' f=1000000/15*(-t+1:t-1)/(2*t-1); end   % for UHF 
% A/D conversion (receiver of UHF and VHF radar) is 1 or 0.5 MHz.

if site=='UHF'
 if disp_data~='2' line1=plot(f(t-9:t+9)+40000*(i-1),pyy(t-9:t+9)*pm+3000000*(j-1)); end
 if disp_data~='1' line2=plot(f(t-9:t+9)+40000*(i-1),pyyf(t-9:t+9)*pm+3000000*(j-1),'r'); end
end
if disp_data~='1' set(line2, 'linewidth', 1.0); end
tex=text(20000+40000*(i-1)-600,3000000*(j-1)+3000000*0.80,ppm);
set(tex,'HorizontalAlignment','right');
set(tex,'FontSize',8);

%********************** OUTPUT HEIGHT ******************************

%if i==1,
% alt1=[int2str(fix(height_arr(jj))) ' km'];
% tex3=text(8000+20000*(-1-1),3000000*(j-1)+3000000*0.5,alt1);
% set(tex3,'HorizontalAlignment','center');
%end

if disp_alt=='1',
 if j==1|j==length(height_arr),
  alt1=int2str(fix(height_arr(jj)));
  tex3=text(-20000+40000*(i-1)+600,3000000*(j-1)+3000000*0.5,alt1);
  set(tex3,'HorizontalAlignment','left');
  set(tex3,'FontSize',7);
 end
end
if disp_alt=='2',
 alt1=int2str(fix(height_arr(jj)));
 tex3=text(-20000+40000*(i-1)+600,3000000*(j-1)+3000000*0.5,alt1);
 set(tex3,'HorizontalAlignment','left');
 set(tex3,'FontSize',7);
end

%********************** OUTPUT QUALITY *****************************

if disp_q=='2'|(disp_q=='1' & rem(status(jj),2^5)~=0),
 q1=int2str(fix(rem(status(jj),2^5)));
 tex4=text(-20000+40000*(i-1)+600,3000000*(j-1)+3000000*0.8,q1);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
end

if rem(status(jj),2^5)==0 & status(jj)>=2^5 & disp_q~='0',
 q2=' i';
 tex4=text(-20000+40000*(i-1)+600,3000000*(j-1)+3000000*0.8,q2);
 set(tex4,'HorizontalAlignment','left');
 set(tex4,'Color','r');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for j=1:longitudinal


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for i=1:transversal

%********************** TITLE **************************************

if round(d_time0(3))<10 timeM=int2str(d_time0(3));timeM=['0' timeM];
else timeM=int2str(d_time0(3)); end
if round(d_time0(5))<10 timeD=int2str(d_time0(5));timeD=['0' timeD];
else timeD=int2str(d_time0(5)); end
title0=[int2str(d_time0(1)) timeM timeD]; 
title0=[title0 '  ' title]; 
tex5=text(40000*(5.5-1),(3000000*longitudinal)*1.10,title0);
set(tex5,'HorizontalAlignment','center');
set(tex5,'FontName','times');
set(tex5,'FontSize',15);

%********************** COMMENT ************************************

tex5=text(-20000,-(3000000*longitudinal)*0.06,comment);
set(tex5,'HorizontalAlignment','left');

%********************** PATH ***************************************

if disp_path=='1',
 result_path2=result_path;  % print
 aa=find(result_path2 == '_');
 if ~isempty(aa)
  for k=1:length(aa)
   result_path2=[result_path2(1:aa(k)-1+(k-1)) '\' result_path2(aa(k)+(k-1):length(result_path2))];
  end % for k=1:length(aa)
 end
 tex5=text(-20000,-(3000000*longitudinal)*0.085,['Data from ' result_path2]);
 set(tex5,'HorizontalAlignment','left');
end

%********************** ACF FILE ***********************************

if disp_file=='1'
 a=['ACF file from acf' file000 '.mat to acf' file00 '.mat'];
 tex5=text(-20000,-(3000000*longitudinal)*0.11,a);
 set(tex5,'HorizontalAlignment','left');
end

%********************** SCALE **************************************

if scale~=1,
 tex10=['Power (x' int2str(scale) ')'];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.06,tex10);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** DATE ***************************************

if disp_date=='1'
 tex10=['Made on  ' date];
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.085,tex10);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** PAGE ***************************************

if disp_page=='1'
 tex10=text(20000+40000*(11-2),-(3000000*longitudinal)*0.11,pagenumber);  
 set(tex10,'HorizontalAlignment','right');
end

%********************** FREQENCY ***********************************

%tex10=text(40000*(10-1)-8000,-3000000*0.3,' x 30 kHz ');
%set(tex10,'HorizontalAlignment','left');

hold off;

%********************** PRINT FIGURES ******************************

set(gcf,'PaperOrientation','landscape');
set(gcf,'PaperPosition',[0.25 0.25 11.1929 7.76772]);
set(gcf,'PaperPositionMode','manual');
set(gcf,'PaperType','a4letter');
if PS_file=='2'|PS_file=='4' set(gcf,'Visible','off'); end
if PS_file=='0'
 pause;
end
if PS_file=='1'|PS_file=='2'
 if g==1,
  filename3=['spect' yy mm dd '_' filename2 '_' pulse '_' kst];
  eval(['print  -dpsc2 ' filename3]);
  fprintf(['print ' filename3 '.ps\n']);
 else eval(['print -dpsc2 -append ' filename3]); end % append
end
if PS_file=='3'|PS_file=='4'
 filename2=['spect' yy mm dd '_' filename2 '_' pulse '_' kst];
 eval(['print -dpsc2 ' filename2]);
 fprintf(['print ' filename2 '.ps\n']);
end
close;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % for g=1:paper2
